 ; Ŀ
 ;   Pex - extract Encana title/rev block data to a csv file.              
 ;   Copyright 1996, 1997, 2003 by Rocket Software Ltd.                    
 ;   Camping - is it an admission that civilization was a mistake?         
 ; 

 ; Ŀ
 ;   Egret - returns the ename of the first pcp tblock found.              
 ;   Takes no arguments, assumes that a drawing contains < 2 title blocks. 
 ; 
 (DEFUN EGRET (/ ss)
 ; Ŀ
 ;   There are many PanCanadian/Encana tbs.                                
 ; 
  (if (or (setq ss (ssget "X" (list (cons 2 "T-A003A"))))
          (setq ss (ssget "X" (list (cons 2 "T-A002A"))))
          (setq ss (ssget "X" (list (cons 2 "REPL-A1"))))
          (setq ss (ssget "X" (list (cons 2 "T2A"))))
          (setq ss (ssget "X" (list (cons 2 "T3A-3"))))
          (setq ss (ssget "X" (list (cons 2 "T2A-3"))))
          (setq ss (ssget "X" (list (cons 2 "AMW_TITLE"))))
          (setq ss (ssget "X" (list (cons 2 "PCP-A1"))))
          (setq ss (ssget "X" (list (cons 2 "PCPA1")))))
      (ssname ss 0)))
 ; Ŀ
 ;   Egret end.                                                            
 ; 

 ; Ŀ
 ;   Erevo - read the revs in an Encana tblock into a list of lists.       
 ;   Brooks no arguments, returns a list of rev line sublists.             
 ;   Calls Egret, Exstr, and RRash.                                        
 ; 
 (DEFUN EREVO (/ enam typ entt stop revlst llist)
  (setq enam (egret))
 ; Ŀ
 ;   Find the first rev line.                                              
 ; 
  (while (and (setq enam (entnext enam))
              (/= "SEQEND" (setq typ (cdr (assoc 0 (setq entt (entget enam))))))
              (/= "RD1" (cdr (assoc 2 entt)))))
  (if (= typ "SEQEND") (setq stop T))
 ; Ŀ
 ;   Extract the Rev lines into a list of value lists.                     
 ; 
  (while (and (null stop) (setq revlst (exstr enam 5)))
         (setq enam (car revlst))
         (setq revlst (cdr revlst))
 ; Ŀ
 ;   Call Rrash to convert the first substring in revlst from "A. XXXX"    
 ;   to "XXXX" if there is a leading "*." substring.                       
 ; 
         (setq llist (append llist (list (rrash revlst))))
         (if (/= "RD" (substr (cdr (assoc 2 (entget enam))) 1 2))
             (setq stop t)))
 llist)
 ; Ŀ
 ;   Erevo end.                                                            
 ; 

 ; Ŀ
 ;   Exstr - extract a number of attribute values, return them as a list   
 ;   with the ename of the next following attribute as the first element.  
 ;   Arguments: Enam, the entity name of the first attribute to extract.   
 ;              Num, the number of attributes to extract.                  
 ;                                                                         
 ;   Calls nothing.  But has good intentions otherwise.                    
 ;   Modified: now calls Nocomma.  (Still has good intentions.)            
 ;   Returns a list: (next_ename string1 string2 ... string_num)           
 ; 
 (DEFUN EXSTR (enam num / entt vall malist)
  (repeat num (if (and enam
                      (setq entt (entget enam))
                      (setq vall (cdr (assoc 1 entt))))
                  (progn
                       (setq vall (nocomma vall))
                       (setq malist (cons vall malist))
                       (setq enam (entnext enam)))))
  (cons enam (reverse malist)))
 ; Ŀ
 ;   Exstr end.                                                            
 ; 

 ; Ŀ
 ;   Nocomma - returns a string minus the commas.                          
 ; 
 (DEFUN NOCOMMA (aa / pos len bb)
  (setq pos 1)
  (setq len (strlen aa))
  (while (>= len pos)
         (setq bb (substr aa pos 1))
         (if (= bb ",")
             (setq aa (strcat (substr aa 1 (1- pos)) ";"
                              (substr aa (1+ pos)))))
         (setq pos (1+ pos)))
  aa)
 ; Ŀ
 ;   Nocomma end.                                                          
 ; 

 ; Ŀ
 ;   RRash - reprocess a rev line list.                                    
 ;   (Makes the first string "A. Constr." into "CONSTR.").                 
 ;   Arguments: Sub, a rev line list.                                      
 ;   Assumes that the list contains at least two elements and that         
 ;   the first one one is a string.                                        
 ;   Returns a modified list.                                              
 ; 
 (DEFUN RRASH (sub / dscr)
  (setq dscr (car sub))
 ; Ŀ
 ;   Make sure that the first string contains a dot and space substring.   
 ;   If not then return the string unchanged.                              
 ;   Later: this is a tricky problem since there is no way to tell what    
 ;   someone might do.  "Constr. Bid" matches the pattern "*. *", but      
 ;   causes Rrash to return "Bid".  Using the leading ? or ?? limits the   
 ;   number of characters before the ". " to two, which should be fairly   
 ;   safe, one would be safer but then again who knows?  It is probably    
 ;   better to err on the side of caution, but it is also better to have   
 ;   programming which doesn't require manual touch-ups half the time.     
 ; 
  (if (wcmatch dscr "?. *,??. *")
      (progn
           (while (and dscr (/= dscr "") (/= (substr dscr 1 1) " "))
                  (setq dscr (substr dscr 2)))
           (while (and dscr (= (substr dscr 1 1) " "))
                  (setq dscr (substr dscr 2)))))
  (list (strcase dscr) (cadr sub)))
 ; Ŀ
 ;   RRash end.                                                            
 ; 

 ; Ŀ
 ;   Still - make a list of lists of lists ... into a single level list.   
 ;   Arguments: Alist, which is not surprisingly a list.                   
 ;   Calls nothing, returns a list.                                        
 ; 
 (DEFUN STILL (alist / goon num gnulis sub)
  (setq goon t)
  (while goon
         (setq num 0)
         (setq goon ())
         (setq gnulis ())
         (while (setq sub (nth num alist))
                (setq num (1+ num))
                (if (= (type sub) 'LIST)
                    (progn
                         (setq gnulis (append gnulis sub))
                         (setq goon t))
                    (setq gnulis (append gnulis (list sub)))))
         (setq alist gnulis))
 alist)
 ; Ŀ
 ;   Still end.                                                            
 ; 

 ; Ŀ
 ;   Trout - extract title block data from an Encana title block.          
 ;   Takes one argument, the tb ename.  Returns a list of data.            
 ; 
 (DEFUN TROUT (enam / pcphco rev line1 line2 entt tagg)
  (setq pcphco "")
  (setq rev "")
  (setq line1 "")
  (setq line2 "")
  (while (/= (cdr (assoc 0 (setq entt (entget (setq enam (entnext enam))))))
             "SEQEND")
         (setq tagg (cdr (assoc 2 entt)))
         (cond ((or (= tagg "PCP-FILE-NO") (= tagg "ENCANA-FILE-NO"))
                (setq pcphco (cdr (assoc 1 entt))))
               ((= tagg "RC1")
                (setq rev (cdr (assoc 1 entt))))
               ((= tagg "TITLE1")
                (setq line1 (nocomma (cdr (assoc 1 entt)))))
               ((= tagg "TITLE2")
                (setq line2 (nocomma (cdr (assoc 1 entt)))))))
 (list pcphco (strcat line1 " " line2) rev))
 ; Ŀ
 ;   Trout end.                                                            
 ; 

 ; Ŀ
 ;   Pex.                                                                  
 ; 
 (DEFUN C:PEX (/ dalist rev ralist malist gnu fn)
 ; Ŀ
 ;   The line format in the drawing list drawing is:                       
 ;   Drawing_name,Title,IFA_Date,IFB_Date,IFC_Date,ASB_Date,Rev,Remarks.   
 ;   Pex will duplicate this without remarks...more or less.               
 ;   Call Trout to get the basic information:                              
 ;   Drawing name, Title 1 and Title 2, Rev.                               
 ; 
  (setq dalist (reverse (trout (egret))))
  (setq rev (car dalist))
  (setq dalist (reverse (cdr dalist)))
 ; Ŀ
 ;   The drawing list requires a date in each of the four issue stage      
 ;   attributes.  Unfortunately there is no way to identify from the       
 ;   titleblock which is which when the data is extraced, except for       
 ;   by descriptions which vary widely.                                    
 ;   Also while the columns in the drawing list drawing have hard-coded    
 ;   headings, there are lots more than four possible rev types in a       
 ;   project, thus the eight spaces for revs in an Encana TB.              
 ;   How to deal with this?  Ideally we should have attributes for column  
 ;   headings and the dates would be read into the matching columns.       
 ;   Until we can push that through we will just save the rev data in      
 ;   the required format, at least saving the context, which the           
 ;   insertion routine will try to sort out.                               
 ;   So: Revs: title,date,title,date... 8x                                 
 ;   Call Erevo to get a list of the rev information.                      
 ; 
  (if (setq ralist (erevo))
      (setq ralist (still ralist))
 ; Ŀ
 ;   If the tb is a T3a-3 partial one as used in vendor drawings then      
 ;   Erevo will return nil (largely because T3a-3 doesn't contain any      
 ;   rev attributes) so must make an empty rev list.                       
 ; 
      (setq ralist '("" "" "" "" "" "" "" "" "" "" "" "" "" "" "" "")))
 ; Ŀ
 ;   Combine the data lists Dalist and Ralist into a master list.          
 ; 
  (setq malist (append dalist ralist (list rev)))
 ; Ŀ
 ;   Which gives us Drawing name, Title 1, Title 2, Rev Descr. 1, Date 1,  
 ;   ... up to Description 8 and Date 8, Rev.                              
 ;   Make the list into a .cdf string.                                     
 ; 
  (mapcar '(lambda (sub)
            (if gnu
               (setq gnu (strcat gnu "," (nocomma sub)))
               (setq gnu (nocomma sub))))
          malist)
 ; Ŀ
 ;   Write the data line to the .cdf file.                                 
 ; 
  (setq fn (open (strcat (getvar "dwgprefix") "titledat.cdf") "a"))
  (write-line gnu fn)
  (close fn)
 (princ))